import processing.opengl.*;
import ddf.minim.*;
import processing.pdf.*;

Minim minim;
AudioPlayer song;
wort[] moves;
float xtext=10,ytext=50;
Boolean animation=false,record=false;
PFont myFont;
color farbe=color(random(255),random(255),random(255));

void setup(){

  size(screen.width,screen.height,OPENGL);
  //size(600,600,OPENGL);
  smooth();
  fill(farbe);

  minim = new Minim(this);

  // this loads mysong.mp3 from the data folder
  song = minim.loadFile("always-rising.mp3");
  song.loop();

  //see the available fonts 
  //String[] fontList = PFont.list();
  //println(fontList);

  myFont = createFont("LTe50179.ttf",38); 
  textFont(myFont);

  moves=new wort[250];

  String words[]=new String[0];
  String lines[] = loadStrings("text.txt");
  for (int i=0;i<lines.length;i++) words = concat(words,split(lines[i],' '));
  for (int i=0;i<words.length;i++)println(words[i]);


  for(int i=0;i<moves.length;i++){
    if(xtext>width-300){
      xtext=20;
      ytext+=40;
    }
    moves[i]=new wort(xtext,ytext,words[i]);
    xtext+=textWidth(words[i]);
  }  
}

void draw(){

  if (record) {
    // Note that #### will be replaced with the frame number. Fancy!
    beginRecord(PDF, "frame-####.pdf"); 
        textFont(myFont);
        textMode(SHAPE);
         	

textSize(38);
  }

  background(0);
  fill(0,3);
  rect(0,0,width,height);
  for(int i=0;i<moves.length;i++){
    if(animation==true) moves[i].move();
    moves[i].render();
  }

  if (record) {
    endRecord();
    record = false;
  }
}

void mousePressed(){

  if(animation==true){
    animation=false;
  }
  else{
    animation=true;  
  }
}

void keyPressed(){

  if (key == 'n' || key == 'N') {
    animation=false;
    for(int i=0;i<moves.length;i++){
      moves[i].clear();
    }
  }

  if (key == 's' || key == 'S') {
    saveFrame(frameCount+".png");
  }

  if (key == 'p' || key == 'P') {
    record = true;
  }
}


