import processing.core.*; 
import processing.xml.*; 

import processing.opengl.*; 
import ddf.minim.*; 
import processing.pdf.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class projection2 extends PApplet {





Minim minim;
AudioPlayer song;
wort[] moves;
float xtext=10,ytext=50;
Boolean animation=false,record=false;
PFont myFont;
int farbe=color(random(255),random(255),random(255));

public void setup(){

  size(screen.width,screen.height,OPENGL);
  //size(600,600,OPENGL);
  smooth();
  fill(farbe);

  minim = new Minim(this);

  // this loads mysong.mp3 from the data folder
  song = minim.loadFile("always-rising.mp3");
  song.loop();

  //see the available fonts 
  //String[] fontList = PFont.list();
  //println(fontList);

  myFont = createFont("LTe50179.ttf",38); 
  textFont(myFont);

  moves=new wort[250];

  String words[]=new String[0];
  String lines[] = loadStrings("text.txt");
  for (int i=0;i<lines.length;i++) words = concat(words,split(lines[i],' '));
  for (int i=0;i<words.length;i++)println(words[i]);


  for(int i=0;i<moves.length;i++){
    if(xtext>width-300){
      xtext=20;
      ytext+=40;
    }
    moves[i]=new wort(xtext,ytext,words[i]);
    xtext+=textWidth(words[i]);
  }  
}

public void draw(){

  if (record) {
    // Note that #### will be replaced with the frame number. Fancy!
    beginRecord(PDF, "frame-####.pdf"); 
        textFont(myFont);
        textMode(SHAPE);
         	

textSize(38);
  }

  background(0);
  fill(0,3);
  rect(0,0,width,height);
  for(int i=0;i<moves.length;i++){
    if(animation==true) moves[i].move();
    moves[i].render();
  }

  if (record) {
    endRecord();
    record = false;
  }
}

public void mousePressed(){

  if(animation==true){
    animation=false;
  }
  else{
    animation=true;  
  }
}

public void keyPressed(){

  if (key == 'n' || key == 'N') {
    animation=false;
    for(int i=0;i<moves.length;i++){
      moves[i].clear();
    }
  }

  if (key == 's' || key == 'S') {
    saveFrame(frameCount+".png");
  }

  if (key == 'p' || key == 'P') {
    record = true;
  }
}


class wort{

  float direction=0;
  float dd=2;
  float startx,starty;
  float x,speed=2,y;
  int c=color(random(50,255),0,0);
  String bla;
  public wort(float _x,float _y,String _bla){
    x=_x;
    y=_y;
    bla=_bla;
    startx=x;
    starty=y;
  }

  public void move(){
    direction+=dd;
    if(random(15)<1)dd=random(-1,1);
    x+=sin(radians(direction))*speed;
    y+=cos(radians(direction))*speed;
    if(x>width)x=0;
    if(x<0)x=width;
    if(y>height)y=0;
    if(y<0)y=height;
  }

  public void clear(){
    x=startx;
    y=starty;
    direction=0;
  }


  public void render(){
    fill(c);
    pushMatrix();
    translate(x,y);
    rotate(radians(direction));  
    text(bla,0,0);
    popMatrix();
  }
}


  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#666666", "--stop-color=#cccccc", "projection2" });
  }
}
