/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import processing.core.PApplet;

public abstract class Oscillator
implements AudioSignal {
    protected static final float TWO_PI = (float)Math.PI * 2;
    private float freq;
    private float newFreq;
    private float srate;
    private float amp;
    private float newAmp;
    private float step;
    private float stepSize;
    private boolean port;
    private float portSpeed;
    private float portStep;
    private float pan;
    private float newPan;
    private float leftScale;
    private float rightScale;
    private AudioListener listener;
    private static float panAmpStep = 1.0E-4f;

    public Oscillator(float frequency, float amplitude, float sampleRate) {
        this.newFreq = this.freq = frequency;
        this.newAmp = this.amp = amplitude;
        this.srate = sampleRate;
        this.step = 0.0f;
        this.stepSize = 1.0f / sampleRate;
        this.port = false;
        this.portStep = 0.01f;
        this.pan = 0.0f;
        this.newPan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.listener = null;
    }

    public final float sampleRate() {
        return this.srate;
    }

    public final void setFreq(float f) {
        this.newFreq = f;
        float msStep = (this.newFreq - this.freq) / this.portSpeed;
        float spms = this.srate / 1000.0f;
        this.portStep = msStep / spms;
    }

    public final float frequency() {
        return this.freq;
    }

    public final void setAmp(float a) {
        this.newAmp = PApplet.constrain((float)a, (float)0.0f, (float)1.0f);
    }

    public final float amplitude() {
        return this.amp;
    }

    public final void setPan(float p) {
        this.newPan = PApplet.constrain((float)p, (float)-1.0f, (float)1.0f);
    }

    public final float pan() {
        return this.pan;
    }

    public final void portamento(int millis) {
        if (millis <= 0) {
            Minim.error("Oscillator.portamento: The portamento speed must be greater than zero.");
        }
        this.port = true;
        this.portSpeed = millis;
    }

    public final void noPortamento() {
        this.port = false;
    }

    public final void generate(float[] signal) {
        if (this.port && this.freq != this.newFreq) {
            int i = 0;
            while (i < signal.length) {
                signal[i] = this.amp * this.value(this.step);
                this.freq = Math.abs(this.freq - this.newFreq) < 0.1f ? this.newFreq : (this.freq += this.portStep);
                this.monoStep();
                ++i;
            }
        } else if (this.freq != this.newFreq) {
            int i = 0;
            while (i < signal.length / 2) {
                float fadeOut = PApplet.map((float)i, (float)0.0f, (float)(signal.length / 2), (float)this.amp, (float)0.0f);
                signal[i] = fadeOut * this.value(this.step);
                this.monoStep();
                ++i;
            }
            this.freq = this.newFreq;
            i = signal.length / 2;
            while (i < signal.length) {
                float fadeIn = PApplet.map((float)i, (float)(signal.length / 2), (float)signal.length, (float)0.0f, (float)this.amp);
                signal[i] = fadeIn * this.value(this.step);
                this.monoStep();
                ++i;
            }
        } else {
            int i = 0;
            while (i < signal.length) {
                signal[i] = this.amp * this.value(this.step);
                this.monoStep();
                ++i;
            }
        }
        if (this.listener != null) {
            this.listener.samples(signal);
        }
    }

    public final void generate(float[] left, float[] right) {
        if (this.port && this.freq != this.newFreq) {
            int i = 0;
            while (i < left.length) {
                left[i] = this.leftScale * this.amp * this.value(this.step);
                right[i] = this.rightScale * this.amp * this.value(this.step);
                this.freq = Math.abs(this.freq - this.newFreq) < 0.1f ? this.newFreq : (this.freq += this.portStep);
                this.stereoStep();
                ++i;
            }
        } else if (this.freq != this.newFreq) {
            int i = 0;
            while (i < left.length / 2) {
                float fadeOut = PApplet.map((float)i, (float)0.0f, (float)(left.length / 2), (float)this.amp, (float)0.0f);
                left[i] = this.leftScale * fadeOut * this.value(this.step);
                right[i] = this.rightScale * fadeOut * this.value(this.step);
                this.stereoStep();
                ++i;
            }
            this.freq = this.newFreq;
            i = left.length / 2;
            while (i < left.length) {
                float fadeIn = PApplet.map((float)i, (float)(left.length / 2), (float)left.length, (float)0.0f, (float)this.amp);
                left[i] = this.leftScale * fadeIn * this.value(this.step);
                right[i] = this.rightScale * fadeIn * this.value(this.step);
                this.stereoStep();
                ++i;
            }
        } else {
            int i = 0;
            while (i < left.length) {
                left[i] = this.leftScale * this.amp * this.value(this.step);
                right[i] = this.rightScale * this.amp * this.value(this.step);
                this.stereoStep();
                ++i;
            }
        }
        if (this.listener != null) {
            this.listener.samples(left, right);
        }
    }

    public final void setAudioListener(AudioListener al) {
        this.listener = al;
    }

    private void monoStep() {
        this.stepStep();
        this.stepAmp();
    }

    private void stereoStep() {
        this.stepStep();
        this.stepAmp();
        this.calcLRScale();
        this.stepPan();
    }

    private void stepStep() {
        this.step += this.stepSize;
        if (this.step > this.period()) {
            this.step %= this.period();
        }
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = PApplet.map((float)this.pan, (float)-1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = PApplet.map((float)this.pan, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    private void stepPan() {
        if (this.pan != this.newPan) {
            this.pan = this.pan < this.newPan ? (this.pan += panAmpStep) : (this.pan -= panAmpStep);
            if (Math.abs(this.pan - this.newPan) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    private void stepAmp() {
        if (this.amp != this.newAmp) {
            this.amp = this.amp < this.newAmp ? (this.amp += panAmpStep) : (this.amp -= panAmpStep);
            if (Math.abs(this.amp - this.newAmp) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    public final float period() {
        return 1.0f / this.freq;
    }

    protected abstract float value(float var1);
}

