/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.mimin.javasound.JSMinim;
import ddf.minim.AudioInput;
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioRecorder;
import ddf.minim.AudioSample;
import ddf.minim.AudioSnippet;
import ddf.minim.Recordable;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.AudioSynthesizer;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import javax.sound.sampled.AudioFileFormat;
import processing.core.PApplet;

public class Minim {
    public static final int MONO = 1;
    public static final int STEREO = 2;
    public static final int LOOP_CONTINUOUSLY = -1;
    public static AudioFileFormat.Type WAV = AudioFileFormat.Type.WAVE;
    public static AudioFileFormat.Type AIFF = AudioFileFormat.Type.AIFF;
    public static AudioFileFormat.Type AIFC = AudioFileFormat.Type.AIFC;
    public static AudioFileFormat.Type AU = AudioFileFormat.Type.AU;
    public static AudioFileFormat.Type SND = AudioFileFormat.Type.SND;
    private static boolean DEBUG = false;
    private MinimServiceProvider mimp = null;

    public Minim(PApplet parent) {
        this.mimp = new JSMinim(parent);
    }

    public Minim(PApplet parent, MinimServiceProvider msp) {
        this.mimp = msp;
        this.mimp.start();
    }

    public static void error(String s) {
        PApplet.println((String)"=== Minim Error ===");
        PApplet.println((String)("=== " + s));
        PApplet.println();
    }

    public static void debug(String s) {
        if (DEBUG) {
            String[] lines = s.split("\n");
            PApplet.println((String)"=== Minim Debug ===");
            int i = 0;
            while (i < lines.length) {
                PApplet.println((String)("=== " + lines[i]));
                ++i;
            }
            PApplet.println();
        }
    }

    public void debugOn() {
        DEBUG = true;
        if (this.mimp != null) {
            this.mimp.debugOn();
        }
    }

    public void debugOff() {
        DEBUG = false;
        if (this.mimp != null) {
            this.mimp.debugOff();
        }
    }

    public void stop() {
        this.mimp.stop();
    }

    public AudioSample loadSample(String filename) {
        return this.loadSample(filename, 1024);
    }

    public AudioSample loadSample(String filename, int bufferSize) {
        return this.mimp.getAudioSample(filename, bufferSize);
    }

    public AudioSnippet loadSnippet(String filename) {
        AudioRecording c = this.mimp.getAudioRecording(filename);
        if (c != null) {
            return new AudioSnippet(c);
        }
        Minim.error("Couldn't load the file " + filename);
        return null;
    }

    public AudioPlayer loadFile(String filename) {
        return this.loadFile(filename, 1024);
    }

    public AudioPlayer loadFile(String filename, int bufferSize) {
        AudioRecordingStream rec = this.mimp.getAudioRecordingStream(filename, bufferSize);
        if (rec != null) {
            return new AudioPlayer(rec);
        }
        Minim.error("Couldn't load the file " + filename);
        return null;
    }

    public AudioRecorder createRecorder(Recordable source, String fileName, boolean buffered) {
        SampleRecorder rec = this.mimp.getSampleRecorder(source, fileName, buffered);
        if (rec != null) {
            return new AudioRecorder(source, rec);
        }
        Minim.error("Couldn't create a SampleRecorder.");
        return null;
    }

    public AudioInput getLineIn() {
        return this.getLineIn(2);
    }

    public AudioInput getLineIn(int type) {
        return this.getLineIn(type, 1024, 44100.0f, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize) {
        return this.getLineIn(type, bufferSize, 44100.0f, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize, float sampleRate) {
        return this.getLineIn(type, bufferSize, sampleRate, 16);
    }

    public AudioInput getLineIn(int type, int bufferSize, float sampleRate, int bitDepth) {
        AudioStream stream = this.mimp.getAudioStream(type, bufferSize, sampleRate, bitDepth);
        if (stream != null) {
            return new AudioInput(stream);
        }
        Minim.error("Minim.getLineIn: attempt failed, could not secure an AudioInput.");
        return null;
    }

    public AudioOutput getLineOut() {
        return this.getLineOut(2);
    }

    public AudioOutput getLineOut(int type) {
        return this.getLineOut(type, 1024, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize) {
        return this.getLineOut(type, bufferSize, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize, float sampleRate) {
        return this.getLineOut(type, bufferSize, sampleRate, 16);
    }

    public AudioOutput getLineOut(int type, int bufferSize, float sampleRate, int bitDepth) {
        AudioSynthesizer synth = this.mimp.getAudioSynthesizer(type, bufferSize, sampleRate, bitDepth);
        if (synth != null) {
            return new AudioOutput(synth);
        }
        Minim.error("Minim.getLineOut: attempt failed, could not secure a LineOut.");
        return null;
    }
}

