/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.FunctionAvailabilityCache;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WGLExtImpl;
import com.sun.opengl.impl.windows.WGLExtProcAddressTable;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public class WindowsGLContext
extends GLContextImpl {
    protected WindowsGLDrawable drawable;
    protected long hglrc;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private static final Map functionNameMap;
    private static final Map extensionNameMap;
    private WGLExt wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WindowsGLContext(WindowsGLDrawable windowsGLDrawable, GLContext gLContext) {
        this(windowsGLDrawable, gLContext, false);
    }

    public WindowsGLContext(WindowsGLDrawable windowsGLDrawable, GLContext gLContext, boolean bl) {
        super(gLContext, bl);
        this.drawable = windowsGLDrawable;
    }

    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    public WGLExt getWGLExt() {
        if (this.wglExt == null) {
            this.wglExt = new WGLExtImpl(this);
        }
        return this.wglExt;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        String string2 = (String)extensionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected void create() {
        if (this.drawable.getHDC() == 0L) {
            throw new GLException("Internal error: attempted to create OpenGL context without an associated drawable");
        }
        this.hglrc = WGL.wglCreateContext(this.drawable.getHDC());
        if (this.hglrc == 0L) {
            throw new GLException("Unable to create OpenGL context for device context " + WindowsGLContext.toHexString(this.drawable.getHDC()));
        }
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Created OpenGL context " + WindowsGLContext.toHexString(this.hglrc) + " for " + this + ", device context " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", not yet sharing");
        }
        WindowsGLContext windowsGLContext = (WindowsGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (windowsGLContext != null) {
            l = windowsGLContext.getHGLRC();
            if (l == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            if (!WGL.wglShareLists(l, this.hglrc)) {
                throw new GLException("wglShareLists(" + WindowsGLContext.toHexString(l) + ", " + WindowsGLContext.toHexString(this.hglrc) + ") failed: error code " + WGL.GetLastError());
            }
        }
        GLContextShareSet.contextCreated(this);
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Created OpenGL context " + WindowsGLContext.toHexString(this.hglrc) + " for " + this + ", device context " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", sharing with " + WindowsGLContext.toHexString(l));
        }
    }

    protected int makeCurrentImpl() throws GLException {
        boolean bl = false;
        if (this.hglrc == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(WindowsGLContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        boolean bl2 = false;
        if (NO_FREE && WGL.wglGetCurrentContext() == this.hglrc) {
            if (DEBUG && VERBOSE) {
                System.err.println(WindowsGLContext.getThreadName() + ": skipping wglMakeCurrent because context already current");
            }
            bl2 = true;
        }
        if (!bl2) {
            if (!WGL.wglMakeCurrent(this.drawable.getHDC(), this.hglrc)) {
                throw new GLException("Error making context current: " + WGL.GetLastError());
            }
            if (DEBUG && VERBOSE) {
                System.err.println(WindowsGLContext.getThreadName() + ": wglMakeCurrent(hdc " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", hglrc " + WindowsGLContext.toHexString(this.hglrc) + ") succeeded");
            }
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (!NO_FREE && !WGL.wglMakeCurrent(0L, 0L)) {
            throw new GLException("Error freeing OpenGL context: " + WGL.GetLastError());
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.hglrc != 0L) {
            if (!WGL.wglDeleteContext(this.hglrc)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println(WindowsGLContext.getThreadName() + ": !!! Destroyed OpenGL context " + WindowsGLContext.toHexString(this.hglrc));
            }
            this.hglrc = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    public boolean isCreated() {
        return this.hglrc != 0L;
    }

    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getHGLRC();
        long l2 = ((WindowsGLContext)gLContext).getHGLRC();
        if (l2 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (!WGL.wglCopyContext(l2, l, n)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Initializing WGL extension address table for " + this);
        }
        this.resetProcAddressTable(this.getWGLExtProcAddressTable());
    }

    public WGLExtProcAddressTable getWGLExtProcAddressTable() {
        if (this.wglExtProcAddressTable == null) {
            this.wglExtProcAddressTable = new WGLExtProcAddressTable();
        }
        return this.wglExtProcAddressTable;
    }

    public String getPlatformExtensionsString() {
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            return this.getWGLExt().wglGetExtensionsStringEXT();
        }
        return "";
    }

    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        if (!$assertionsDisabled && bl && this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) == 0L && !FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string))) {
            throw new AssertionError();
        }
        return bl;
    }

    public void setSwapInterval(int n) {
        WGLExt wGLExt = this.getWGLExt();
        if (wGLExt.isExtensionAvailable("WGL_EXT_swap_control")) {
            wGLExt.wglSwapIntervalEXT(n);
        }
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getWGLExt().wglAllocateMemoryNV(n, f, f2, f3);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public long getHGLRC() {
        return this.hglrc;
    }

    static {
        $assertionsDisabled = !WindowsGLContext.class.desiredAssertionStatus();
        functionNameMap = new HashMap();
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

